/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URL;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.actions.ChangeRequestAction;
import org.kohsuke.github.GHPullRequest;

final class PullRequestAction
extends ChangeRequestAction {
    private static final long serialVersionUID = 1L;
    private final int number;
    private final URL url;
    private final String title;
    private final String userLogin;
    private final String baseRef;

    PullRequestAction(GHPullRequest pr) {
        this.number = pr.getNumber();
        this.url = pr.getHtmlUrl();
        this.title = pr.getTitle();
        this.userLogin = pr.getUser().getLogin();
        this.baseRef = pr.getBase().getRef();
    }

    @NonNull
    public String getId() {
        return Integer.toString(this.number);
    }

    @NonNull
    public URL getURL() {
        return this.url;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAuthor() {
        return this.userLogin;
    }

    @NonNull
    public SCMHead getTarget() {
        return new SCMHead(this.baseRef);
    }
}

