/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubWebHook;
import hudson.Extension;
import hudson.security.ACL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

@Extension
public class GitHubWebhookListenerImpl
extends GitHubWebHook.Listener {
    private static final Logger LOGGER = Logger.getLogger(GitHubWebhookListenerImpl.class.getName());

    public void onPushRepositoryChanged(final String pusherName, final GitHubRepositoryName changedRepository) {
        Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean found = false;
                        for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                            for (SCMSource source : owner.getSCMSources()) {
                                GitHubSCMSource gitHubSCMSource;
                                if (!(source instanceof GitHubSCMSource) || !(gitHubSCMSource = (GitHubSCMSource)source).getRepoOwner().equals(changedRepository.getUserName()) || !gitHubSCMSource.getRepository().equals(changedRepository.getRepositoryName())) continue;
                                found = true;
                                LOGGER.log(Level.FINE, "push event from {0} on {1}:{2}/{3} forwarded to {4}", new Object[]{pusherName, changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName(), owner.getFullName()});
                                owner.onSCMSourceUpdated((SCMSource)gitHubSCMSource);
                            }
                        }
                        if (!found) {
                            LOGGER.log(Level.FINE, "push event from {0} on {1}:{2}/{3} did not match any project", new Object[]{pusherName, changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName()});
                        }
                    }
                });
            }
        }, 5L, TimeUnit.SECONDS);
    }
}

