/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.util.MergeRecord;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.HttpsRepositoryUriResolver;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.PullRequestAction;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.jenkinsci.plugins.github_branch_source.RepositoryUriResolver;
import org.jenkinsci.plugins.github_branch_source.SshRepositoryUriResolver;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitHubSCMSource
extends AbstractGitSCMSource {
    private static final Logger LOGGER = Logger.getLogger(GitHubSCMSource.class.getName());
    private final String apiUri;
    private final String checkoutCredentialsId;
    private final String scanCredentialsId;
    private final String repoOwner;
    private final String repository;
    @Nonnull
    private String includes = "*";
    @Nonnull
    private String excludes = "";
    @Nonnull
    private Boolean buildOriginBranch = true;
    @Nonnull
    private Boolean buildOriginBranchWithPR = true;
    @Nonnull
    private Boolean buildOriginPRMerge = false;
    @Nonnull
    private Boolean buildOriginPRHead = false;
    @Nonnull
    private Boolean buildForkPRMerge = true;
    @Nonnull
    private Boolean buildForkPRHead = false;

    @DataBoundConstructor
    public GitHubSCMSource(String id, String apiUri, String checkoutCredentialsId, String scanCredentialsId, String repoOwner, String repository) {
        super(id);
        this.apiUri = Util.fixEmpty((String)apiUri);
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.scanCredentialsId = Util.fixEmpty((String)scanCredentialsId);
        this.checkoutCredentialsId = checkoutCredentialsId;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() {
        if (this.buildOriginBranch == null) {
            this.buildOriginBranch = true;
        }
        if (this.buildOriginBranchWithPR == null) {
            this.buildOriginBranchWithPR = true;
        }
        if (this.buildOriginPRMerge == null) {
            this.buildOriginPRMerge = false;
        }
        if (this.buildOriginPRHead == null) {
            this.buildOriginPRHead = false;
        }
        if (this.buildForkPRMerge == null) {
            this.buildForkPRMerge = true;
        }
        if (this.buildForkPRHead == null) {
            this.buildForkPRHead = false;
        }
        return this;
    }

    @CheckForNull
    public String getApiUri() {
        return this.apiUri;
    }

    @CheckForNull
    public String getCredentialsId() {
        if ("ANONYMOUS".equals(this.checkoutCredentialsId)) {
            return null;
        }
        if ("SAME".equals(this.checkoutCredentialsId)) {
            return this.scanCredentialsId;
        }
        return this.checkoutCredentialsId;
    }

    @CheckForNull
    public String getScanCredentialsId() {
        return this.scanCredentialsId;
    }

    @CheckForNull
    public String getCheckoutCredentialsId() {
        return this.checkoutCredentialsId;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getRepository() {
        return this.repository;
    }

    protected List<RefSpec> getRefSpecs() {
        return new ArrayList<RefSpec>(Arrays.asList(new RefSpec("+refs/heads/*:refs/remotes/origin/*"), new RefSpec("+refs/pull/*/head:refs/remotes/origin/pr/*")));
    }

    public RepositoryUriResolver getUriResolver() {
        String credentialsId = this.getCredentialsId();
        if (credentialsId == null) {
            return new HttpsRepositoryUriResolver();
        }
        if (this.getCredentials(StandardCredentials.class, credentialsId) instanceof SSHUserPrivateKey) {
            return new SshRepositoryUriResolver();
        }
        return new HttpsRepositoryUriResolver();
    }

    private <T extends StandardCredentials> T getCredentials(@Nonnull Class<T> type, @Nonnull String credentialsId) {
        return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(type, (Item)this.getOwner(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(type)})));
    }

    @Nonnull
    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(@Nonnull String includes) {
        this.includes = includes;
    }

    @Nonnull
    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(@Nonnull String excludes) {
        this.excludes = excludes;
    }

    public boolean getBuildOriginBranch() {
        return this.buildOriginBranch;
    }

    @DataBoundSetter
    public void setBuildOriginBranch(boolean buildOriginBranch) {
        this.buildOriginBranch = buildOriginBranch;
    }

    public boolean getBuildOriginBranchWithPR() {
        return this.buildOriginBranchWithPR;
    }

    @DataBoundSetter
    public void setBuildOriginBranchWithPR(boolean buildOriginBranchWithPR) {
        this.buildOriginBranchWithPR = buildOriginBranchWithPR;
    }

    public boolean getBuildOriginPRMerge() {
        return this.buildOriginPRMerge;
    }

    @DataBoundSetter
    public void setBuildOriginPRMerge(boolean buildOriginPRMerge) {
        this.buildOriginPRMerge = buildOriginPRMerge;
    }

    public boolean getBuildOriginPRHead() {
        return this.buildOriginPRHead;
    }

    @DataBoundSetter
    public void setBuildOriginPRHead(boolean buildOriginPRHead) {
        this.buildOriginPRHead = buildOriginPRHead;
    }

    public boolean getBuildForkPRMerge() {
        return this.buildForkPRMerge;
    }

    @DataBoundSetter
    public void setBuildForkPRMerge(boolean buildForkPRMerge) {
        this.buildForkPRMerge = buildForkPRMerge;
    }

    public boolean getBuildForkPRHead() {
        return this.buildForkPRHead;
    }

    @DataBoundSetter
    public void setBuildForkPRHead(boolean buildForkPRHead) {
        this.buildForkPRHead = buildForkPRHead;
    }

    public String getRemote() {
        return this.getUriResolver().getRepositoryUri(this.apiUri, this.repoOwner, this.repository);
    }

    protected final void retrieve(SCMHeadObserver observer, TaskListener listener) throws IOException, InterruptedException {
        StandardCredentials credentials = Connector.lookupScanCredentials(this.getOwner(), this.apiUri, this.scanCredentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            github.checkApiUrlValidity();
        }
        catch (HttpException e) {
            String message = String.format("It seems %s is unreachable", this.apiUri == null ? "https://api.github.com" : this.apiUri);
            throw new AbortException(message);
        }
        try {
            if (credentials != null && !github.isCredentialValid()) {
                String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), this.apiUri == null ? "https://api.github.com" : this.apiUri);
                throw new AbortException(message);
            }
            if (!github.isAnonymous()) {
                listener.getLogger().format("Connecting to %s using %s%n", this.apiUri == null ? "https://api.github.com" : this.apiUri, CredentialsNameProvider.name((Credentials)credentials));
            } else {
                listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.apiUri == null ? "https://api.github.com" : this.apiUri);
            }
            if (this.repository == null || this.repository.isEmpty()) {
                throw new AbortException("No repository selected, skipping");
            }
            String fullName = this.repoOwner + "/" + this.repository;
            GHRepository repo = github.getRepository(fullName);
            listener.getLogger().format("Looking up %s%n", HyperlinkNote.encodeTo((String)repo.getHtmlUrl().toString(), (String)fullName));
            this.doRetrieve(observer, listener, repo);
            listener.getLogger().format("%nDone examining %s%n%n", fullName);
        }
        catch (RateLimitExceededException rle) {
            throw new AbortException(rle.getMessage());
        }
    }

    private void doRetrieve(SCMHeadObserver observer, TaskListener listener, GHRepository repo) throws IOException, InterruptedException {
        SCMSourceCriteria criteria = this.getCriteria();
        HashSet<String> originBranchesWithPR = new HashSet<String>();
        if (this.buildOriginBranchWithPR.booleanValue() || this.buildOriginPRMerge.booleanValue() || this.buildOriginPRHead.booleanValue() || this.buildForkPRMerge.booleanValue() || this.buildForkPRHead.booleanValue()) {
            listener.getLogger().format("%n  Getting remote pull requests...%n", new Object[0]);
            int pullrequests = 0;
            for (GHPullRequest gHPullRequest : repo.getPullRequests(GHIssueState.OPEN)) {
                boolean trusted;
                boolean fork;
                int number = gHPullRequest.getNumber();
                listener.getLogger().format("%n    Checking pull request %s%n", HyperlinkNote.encodeTo((String)gHPullRequest.getHtmlUrl().toString(), (String)("#" + number)));
                boolean bl = fork = !repo.getOwner().equals((Object)gHPullRequest.getHead().getUser());
                if (fork && !this.buildForkPRMerge.booleanValue() && !this.buildForkPRHead.booleanValue()) {
                    listener.getLogger().format("    Submitted from fork, skipping%n%n", new Object[0]);
                    continue;
                }
                if (!(fork || this.buildOriginPRMerge.booleanValue() || this.buildOriginPRHead.booleanValue() || this.buildOriginBranchWithPR.booleanValue())) {
                    listener.getLogger().format("    Submitted from origin repository, skipping%n%n", new Object[0]);
                    continue;
                }
                if (!fork) {
                    originBranchesWithPR.add(gHPullRequest.getHead().getRef());
                }
                if (!(trusted = this.isTrusted(repo, gHPullRequest))) {
                    listener.getLogger().format("    (not from a trusted source)%n", new Object[0]);
                }
                for (boolean merge : new boolean[]{false, true}) {
                    String branchName = "PR-" + number;
                    if (merge && fork) {
                        if (!this.buildForkPRMerge.booleanValue()) continue;
                        if (this.buildForkPRHead.booleanValue()) {
                            branchName = branchName + "-merge";
                        }
                    }
                    if (merge && !fork) {
                        if (!this.buildOriginPRMerge.booleanValue()) continue;
                        if (this.buildForkPRHead.booleanValue()) {
                            branchName = branchName + "-merge";
                        }
                    }
                    if (!merge && fork) {
                        if (!this.buildForkPRHead.booleanValue()) continue;
                        if (this.buildForkPRMerge.booleanValue()) {
                            branchName = branchName + "-head";
                        }
                    }
                    if (!merge && !fork) {
                        if (!this.buildOriginPRHead.booleanValue()) continue;
                        if (this.buildOriginPRMerge.booleanValue()) {
                            branchName = branchName + "-head";
                        }
                    }
                    listener.getLogger().format("    Job name: %s%n", branchName);
                    PullRequestSCMHead head = new PullRequestSCMHead(gHPullRequest, branchName, merge, trusted);
                    if (criteria != null) {
                        SCMSourceCriteria.Probe probe = this.getProbe(branchName, "pull request", "refs/pull/" + number + (merge ? "/merge" : "/head"), repo, listener);
                        if (criteria.isHead(probe, listener)) {
                            Boolean mergeable = gHPullRequest.getMergeable();
                            if (Boolean.FALSE.equals(mergeable)) {
                                if (merge) {
                                    listener.getLogger().format("      Not mergeable, build likely to fail%n", new Object[0]);
                                } else {
                                    listener.getLogger().format("      Not mergeable, but will be built anyway%n", new Object[0]);
                                }
                            }
                            listener.getLogger().format("    Met criteria%n", new Object[0]);
                        } else {
                            listener.getLogger().format("    Does not meet criteria%n", new Object[0]);
                            continue;
                        }
                    }
                    String baseHash = merge ? repo.getRef("heads/" + gHPullRequest.getBase().getRef()).getObject().getSha() : gHPullRequest.getBase().getSha();
                    PullRequestSCMRevision rev = new PullRequestSCMRevision(head, baseHash, gHPullRequest.getHead().getSha());
                    observer.observe((SCMHead)head, (SCMRevision)rev);
                    if (observer.isObserving()) continue;
                    return;
                }
                ++pullrequests;
            }
            listener.getLogger().format("%n  %d pull requests were processed%n", pullrequests);
        }
        if (this.buildOriginBranch.booleanValue() || this.buildOriginBranchWithPR.booleanValue()) {
            listener.getLogger().format("%n  Getting remote branches...%n", new Object[0]);
            int branches = 0;
            for (Map.Entry entry : repo.getBranches().entrySet()) {
                String branchName = (String)entry.getKey();
                if (this.isExcluded(branchName)) continue;
                boolean hasPR = originBranchesWithPR.contains(branchName);
                if (!hasPR && !this.buildOriginBranch.booleanValue()) {
                    listener.getLogger().format("%n    Skipping branch %s since there is no corresponding PR%n", branchName);
                    continue;
                }
                if (hasPR && !this.buildOriginBranchWithPR.booleanValue()) {
                    listener.getLogger().format("%n    Skipping branch %s since there is a corresponding PR%n", branchName);
                    continue;
                }
                listener.getLogger().format("%n    Checking branch %s%n", HyperlinkNote.encodeTo((String)(repo.getHtmlUrl().toString() + "/tree/" + branchName), (String)branchName));
                if (criteria != null) {
                    SCMSourceCriteria.Probe probe = this.getProbe(branchName, "branch", "refs/heads/" + branchName, repo, listener);
                    if (criteria.isHead(probe, listener)) {
                        listener.getLogger().format("    Met criteria%n", new Object[0]);
                    } else {
                        listener.getLogger().format("    Does not meet criteria%n", new Object[0]);
                        continue;
                    }
                }
                SCMHead head = new SCMHead(branchName);
                AbstractGitSCMSource.SCMRevisionImpl hash = new AbstractGitSCMSource.SCMRevisionImpl(head, ((GHBranch)entry.getValue()).getSHA1());
                observer.observe(head, (SCMRevision)hash);
                if (!observer.isObserving()) {
                    return;
                }
                ++branches;
            }
            listener.getLogger().format("%n  %d branches were processed%n", branches);
        }
    }

    protected SCMSourceCriteria.Probe getProbe(final String branch, final String thing, final String ref, final GHRepository repo, final TaskListener listener) {
        return new SCMSourceCriteria.Probe(){
            private static final long serialVersionUID = 5012552654534124387L;

            public String name() {
                return branch;
            }

            public long lastModified() {
                return 0L;
            }

            public boolean exists(@Nonnull String path) throws IOException {
                try {
                    int index = path.lastIndexOf(47) + 1;
                    List directoryContent = repo.getDirectoryContent(path.substring(0, index), ref);
                    for (GHContent content : directoryContent) {
                        if (!content.isFile()) continue;
                        String filename = path.substring(index);
                        if (content.getName().equals(filename)) {
                            listener.getLogger().format("      \u2018%s\u2019 exists in this %s%n", path, thing);
                            return true;
                        }
                        if (!content.getName().equalsIgnoreCase(filename)) continue;
                        listener.getLogger().format("      \u2018%s\u2019 not found (but found \u2018%s\u2019, search is case sensitive) in this %s, skipping%n", path, content.getName(), thing);
                        return false;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                listener.getLogger().format("      \u2018%s\u2019 does not exist in this %s%n", path, thing);
                return false;
            }
        };
    }

    @CheckForNull
    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        StandardCredentials credentials = Connector.lookupScanCredentials(this.getOwner(), this.apiUri, this.scanCredentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            github.checkApiUrlValidity();
        }
        catch (HttpException e) {
            String message = String.format("It seems %s is unreachable", this.apiUri == null ? "https://api.github.com" : this.apiUri);
            throw new AbortException(message);
        }
        try {
            if (credentials != null && !github.isCredentialValid()) {
                String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), this.apiUri == null ? "https://api.github.com" : this.apiUri);
                throw new AbortException(message);
            }
            if (!github.isAnonymous()) {
                listener.getLogger().format("Connecting to %s using %s%n", this.apiUri == null ? "https://api.github.com" : this.apiUri, CredentialsNameProvider.name((Credentials)credentials));
            } else {
                listener.getLogger().format("Connecting to %s using anonymous access%n", this.apiUri == null ? "https://api.github.com" : this.apiUri);
            }
            String fullName = this.repoOwner + "/" + this.repository;
            GHRepository repo = github.getRepository(fullName);
            return this.doRetrieve(head, listener, repo);
        }
        catch (RateLimitExceededException rle) {
            throw new AbortException(rle.getMessage());
        }
    }

    protected SCMRevision doRetrieve(SCMHead head, TaskListener listener, GHRepository repo) throws IOException, InterruptedException {
        if (head instanceof PullRequestSCMHead) {
            String baseHash;
            PullRequestSCMHead prhead = (PullRequestSCMHead)head;
            int number = prhead.getNumber();
            GHPullRequest pr = repo.getPullRequest(number);
            if (prhead.isMerge()) {
                PullRequestAction metadata = (PullRequestAction)prhead.getAction(PullRequestAction.class);
                if (metadata == null) {
                    throw new IOException("Cannot find base branch metadata from " + (Object)((Object)prhead));
                }
                baseHash = repo.getRef("heads/" + metadata.getTarget().getName()).getObject().getSha();
            } else {
                baseHash = pr.getBase().getSha();
            }
            return new PullRequestSCMRevision((PullRequestSCMHead)head, baseHash, pr.getHead().getSha());
        }
        return new AbstractGitSCMSource.SCMRevisionImpl(head, repo.getRef("heads/" + head.getName()).getObject().getSha());
    }

    public SCM build(SCMHead head, SCMRevision revision) {
        if (revision == null) {
            return super.build(head, null);
        }
        if (head instanceof PullRequestSCMHead) {
            if (!(revision instanceof PullRequestSCMRevision)) {
                LOGGER.log(Level.WARNING, "Unexpected revision class {0} for {1}", new Object[]{revision.getClass().getName(), head});
                return super.build(head, revision);
            }
            PullRequestSCMRevision prRev = (PullRequestSCMRevision)revision;
            GitSCM scm = (GitSCM)super.build(head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head, prRev.getPullHash()));
            if (((PullRequestSCMHead)head).isMerge()) {
                PullRequestAction action = (PullRequestAction)head.getAction(PullRequestAction.class);
                String baseName = action != null ? action.getTarget().getName() : "master?";
                scm.getExtensions().add((Object)new MergeWith(baseName, prRev.getBaseHash()));
            }
            return scm;
        }
        return super.build(head, (SCMRevision)((AbstractGitSCMSource.SCMRevisionImpl)revision));
    }

    public SCMRevision getTrustedRevision(SCMRevision revision, TaskListener listener) throws IOException, InterruptedException {
        if (revision instanceof PullRequestSCMRevision && !((PullRequestSCMHead)revision.getHead()).isTrusted()) {
            PullRequestAction metadata = (PullRequestAction)revision.getHead().getAction(PullRequestAction.class);
            if (metadata != null) {
                PullRequestSCMRevision rev = (PullRequestSCMRevision)revision;
                listener.getLogger().println("Loading trusted files from base branch " + metadata.getTarget().getName() + " at " + rev.getBaseHash() + " rather than " + rev.getPullHash());
                return new AbstractGitSCMSource.SCMRevisionImpl(metadata.getTarget(), rev.getBaseHash());
            }
            throw new IOException("Cannot find base branch metadata from " + revision.getHead());
        }
        return revision;
    }

    private boolean isTrusted(@Nonnull GHRepository repo, @Nonnull GHPullRequest ghPullRequest) throws IOException {
        return repo.getCollaboratorNames().contains(ghPullRequest.getUser().getLogin());
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public static final String defaultIncludes = "*";
        public static final String defaultExcludes = "";
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String SAME = "SAME";
        public static final boolean defaultBuildOriginBranch = true;
        public static final boolean defaultBuildOriginBranchWithPR = true;
        public static final boolean defaultBuildOriginPRMerge = false;
        public static final boolean defaultBuildOriginPRHead = false;
        public static final boolean defaultBuildForkPRMerge = true;
        public static final boolean defaultBuildForkPRHead = false;

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.github_branch_source.OriginGitHubSCMSource", GitHubSCMSource.class);
        }

        public String getDisplayName() {
            return "GitHub";
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckIncludes(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.warning((String)Messages.GitHubSCMSource_did_you_mean_to_use_to_match_all_branches());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckScanCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String scanCredentialsId, @QueryParameter String apiUri) {
            if (!scanCredentialsId.isEmpty()) {
                StandardCredentials credentials = Connector.lookupScanCredentials(context, apiUri, scanCredentialsId);
                if (credentials == null) {
                    return FormValidation.error((String)"Credentials not found");
                }
                try {
                    GitHub connector = Connector.connect(apiUri, credentials);
                    if (connector.isCredentialValid()) {
                        return FormValidation.ok();
                    }
                    return FormValidation.error((String)"Invalid credentials");
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception validating credentials {0} on {1}", new Object[]{CredentialsNameProvider.name((Credentials)credentials), apiUri});
                    return FormValidation.error((String)"Exception validating credentials");
                }
            }
            return FormValidation.warning((String)"Credentials are recommended");
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildOriginBranchWithPR(@QueryParameter boolean buildOriginBranch, @QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead, @QueryParameter boolean buildForkPRMerge, @QueryParameter boolean buildForkPRHead) {
            if (!(!buildOriginBranch || buildOriginBranchWithPR || buildOriginPRMerge || buildOriginPRHead || buildForkPRMerge || buildForkPRHead)) {
                return FormValidation.warning((String)"If you are not building any PRs, all origin branches will be built.");
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildOriginPRHead(@QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead) {
            if (buildOriginBranchWithPR && buildOriginPRHead) {
                return FormValidation.warning((String)"Redundant to build an origin PR both as a branch and as an unmerged PR.");
            }
            if (buildOriginPRMerge && buildOriginPRHead) {
                return FormValidation.ok((String)"Merged vs. unmerged PRs will be distinguished in the job name (*-merge vs. *-head).");
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildForkPRHead(@QueryParameter boolean buildOriginBranch, @QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead, @QueryParameter boolean buildForkPRMerge, @QueryParameter boolean buildForkPRHead) {
            if (!(buildOriginBranch || buildOriginBranchWithPR || buildOriginPRMerge || buildOriginPRHead || buildForkPRMerge || buildForkPRHead)) {
                return FormValidation.warning((String)"You need to build something!");
            }
            if (buildForkPRMerge && buildForkPRHead) {
                return FormValidation.ok((String)"Merged vs. unmerged PRs will be distinguished in the job name (*-merge vs. *-head).");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillApiUriItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("GitHub", defaultExcludes);
            for (Endpoint e : GitHubConfiguration.get().getEndpoints()) {
                result.add(e.getName() == null ? e.getApiUri() : e.getName(), e.getApiUri());
            }
            return result;
        }

        public ListBoxModel doFillCheckoutCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String apiUri) {
            StandardListBoxModel result = new StandardListBoxModel();
            result.add("- same as scan credentials -", SAME);
            result.add("- anonymous -", ANONYMOUS);
            Connector.fillCheckoutCredentialsIdItems(result, context, apiUri);
            return result;
        }

        public ListBoxModel doFillScanCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String apiUri) {
            StandardListBoxModel result = new StandardListBoxModel();
            result.withEmptySelection();
            Connector.fillScanCredentialsIdItems(result, context, apiUri);
            return result;
        }

        public ListBoxModel doFillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String apiUri, @QueryParameter String scanCredentialsId, @QueryParameter String repoOwner) {
            TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if ((repoOwner = Util.fixEmptyAndTrim((String)repoOwner)) == null) {
                return DescriptorImpl.nameAndValueModel(result);
            }
            try {
                StandardCredentials credentials = Connector.lookupScanCredentials(context, apiUri, scanCredentialsId);
                GitHub github = Connector.connect(apiUri, credentials);
                if (!github.isAnonymous()) {
                    GHMyself myself = null;
                    try {
                        myself = github.getMyself();
                    }
                    catch (IllegalStateException e) {
                        LOGGER.log(Level.WARNING, e.getMessage());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Exception retrieving the repositories of the owner {0} on {1} with credentials {2}", new Object[]{repoOwner, apiUri, CredentialsNameProvider.name((Credentials)credentials)});
                    }
                    if (myself != null && repoOwner.equalsIgnoreCase(myself.getLogin())) {
                        for (String name : myself.getAllRepositories().keySet()) {
                            result.add(name);
                        }
                        return DescriptorImpl.nameAndValueModel(result);
                    }
                }
                GHOrganization org = null;
                try {
                    org = github.getOrganization(repoOwner);
                }
                catch (FileNotFoundException fnf) {
                    LOGGER.log(Level.FINE, "There is not any GH Organization named {0}", repoOwner);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
                if (org != null && repoOwner.equalsIgnoreCase(org.getLogin())) {
                    LOGGER.log(Level.FINE, "as {0} looking for repositories in {1}", new Object[]{scanCredentialsId, repoOwner});
                    for (GHRepository repo : org.listRepositories(100)) {
                        LOGGER.log(Level.FINE, "as {0} found {1}/{2}", new Object[]{scanCredentialsId, repoOwner, repo.getName()});
                        result.add(repo.getName());
                    }
                    LOGGER.log(Level.FINE, "as {0} result of {1} is {2}", new Object[]{scanCredentialsId, repoOwner, result});
                    return DescriptorImpl.nameAndValueModel(result);
                }
                GHUser user = null;
                try {
                    user = github.getUser(repoOwner);
                }
                catch (FileNotFoundException fnf) {
                    LOGGER.log(Level.FINE, "There is not any GH User named {0}", repoOwner);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
                if (user != null && repoOwner.equalsIgnoreCase(user.getLogin())) {
                    for (GHRepository repo : user.listRepositories(100)) {
                        result.add(repo.getName());
                    }
                    return DescriptorImpl.nameAndValueModel(result);
                }
            }
            catch (SSLHandshakeException he) {
                LOGGER.log(Level.SEVERE, he.getMessage());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
            return DescriptorImpl.nameAndValueModel(result);
        }

        private static ListBoxModel nameAndValueModel(Collection<String> items) {
            ListBoxModel model = new ListBoxModel();
            for (String item : items) {
                model.add(item);
            }
            return model;
        }
    }

    private static class MergeWith
    extends GitSCMExtension {
        private final String baseName;
        private final String baseHash;

        MergeWith(String baseName, String baseHash) {
            this.baseName = baseName;
            this.baseHash = baseHash;
        }

        public Revision decorateRevisionToBuild(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision marked, Revision rev) throws IOException, InterruptedException, GitException {
            listener.getLogger().println("Merging " + this.baseName + " commit " + this.baseHash + " into PR head commit " + rev.getSha1String());
            this.checkout(scm, build, git, listener, rev);
            try {
                git.setAuthor("Jenkins", "nobody@nowhere");
                git.setCommitter("Jenkins", "nobody@nowhere");
                MergeCommand cmd = git.merge().setRevisionToMerge(ObjectId.fromString((String)this.baseHash));
                for (GitSCMExtension ext : scm.getExtensions()) {
                    ext.decorateMergeCommand(scm, build, git, listener, cmd);
                }
                cmd.execute();
            }
            catch (GitException x) {
                this.checkout(scm, build, git, listener, rev);
                throw x;
            }
            build.addAction((Action)new MergeRecord(this.baseName, this.baseHash));
            ObjectId mergeRev = git.revParse("HEAD");
            listener.getLogger().println("Merge succeeded, producing " + mergeRev.name());
            return new Revision(mergeRev, rev.getBranches());
        }

        private void checkout(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision rev) throws InterruptedException, IOException, GitException {
            CheckoutCommand checkoutCommand = git.checkout().ref(rev.getSha1String());
            for (GitSCMExtension ext : scm.getExtensions()) {
                ext.decorateCheckoutCommand(scm, build, git, listener, checkoutCommand);
            }
            checkoutCommand.execute();
        }
    }
}

