/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitHubSCMNavigator
extends SCMNavigator {
    private final String repoOwner;
    private final String scanCredentialsId;
    private final String checkoutCredentialsId;
    private final String apiUri;
    private String pattern = ".*";
    @CheckForNull
    private String includes;
    @CheckForNull
    private String excludes;
    @Nonnull
    private Boolean buildOriginBranch = true;
    @Nonnull
    private Boolean buildOriginBranchWithPR = true;
    @Nonnull
    private Boolean buildOriginPRMerge = false;
    @Nonnull
    private Boolean buildOriginPRHead = false;
    @Nonnull
    private Boolean buildForkPRMerge = true;
    @Nonnull
    private Boolean buildForkPRHead = false;

    @DataBoundConstructor
    public GitHubSCMNavigator(String apiUri, String repoOwner, String scanCredentialsId, String checkoutCredentialsId) {
        this.repoOwner = repoOwner;
        this.scanCredentialsId = Util.fixEmpty((String)scanCredentialsId);
        this.checkoutCredentialsId = checkoutCredentialsId;
        this.apiUri = Util.fixEmpty((String)apiUri);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() {
        if (this.buildOriginBranch == null) {
            this.buildOriginBranch = true;
        }
        if (this.buildOriginBranchWithPR == null) {
            this.buildOriginBranchWithPR = true;
        }
        if (this.buildOriginPRMerge == null) {
            this.buildOriginPRMerge = false;
        }
        if (this.buildOriginPRHead == null) {
            this.buildOriginPRHead = false;
        }
        if (this.buildForkPRMerge == null) {
            this.buildForkPRMerge = true;
        }
        if (this.buildForkPRHead == null) {
            this.buildForkPRHead = false;
        }
        return this;
    }

    @Nonnull
    public String getIncludes() {
        return this.includes != null ? this.includes : "*";
    }

    @DataBoundSetter
    public void setIncludes(@Nonnull String includes) {
        this.includes = includes.equals("*") ? null : includes;
    }

    @Nonnull
    public String getExcludes() {
        return this.excludes != null ? this.excludes : "";
    }

    @DataBoundSetter
    public void setExcludes(@Nonnull String excludes) {
        this.excludes = excludes.equals("") ? null : excludes;
    }

    public boolean getBuildOriginBranch() {
        return this.buildOriginBranch;
    }

    @DataBoundSetter
    public void setBuildOriginBranch(boolean buildOriginBranch) {
        this.buildOriginBranch = buildOriginBranch;
    }

    public boolean getBuildOriginBranchWithPR() {
        return this.buildOriginBranchWithPR;
    }

    @DataBoundSetter
    public void setBuildOriginBranchWithPR(boolean buildOriginBranchWithPR) {
        this.buildOriginBranchWithPR = buildOriginBranchWithPR;
    }

    public boolean getBuildOriginPRMerge() {
        return this.buildOriginPRMerge;
    }

    @DataBoundSetter
    public void setBuildOriginPRMerge(boolean buildOriginPRMerge) {
        this.buildOriginPRMerge = buildOriginPRMerge;
    }

    public boolean getBuildOriginPRHead() {
        return this.buildOriginPRHead;
    }

    @DataBoundSetter
    public void setBuildOriginPRHead(boolean buildOriginPRHead) {
        this.buildOriginPRHead = buildOriginPRHead;
    }

    public boolean getBuildForkPRMerge() {
        return this.buildForkPRMerge;
    }

    @DataBoundSetter
    public void setBuildForkPRMerge(boolean buildForkPRMerge) {
        this.buildForkPRMerge = buildForkPRMerge;
    }

    public boolean getBuildForkPRHead() {
        return this.buildForkPRHead;
    }

    @DataBoundSetter
    public void setBuildForkPRHead(boolean buildForkPRHead) {
        this.buildForkPRHead = buildForkPRHead;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    @CheckForNull
    public String getScanCredentialsId() {
        return this.scanCredentialsId;
    }

    @CheckForNull
    public String getCheckoutCredentialsId() {
        return this.checkoutCredentialsId;
    }

    public String getPattern() {
        return this.pattern;
    }

    @CheckForNull
    public String getApiUri() {
        return this.apiUri;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        Pattern.compile(pattern);
        this.pattern = pattern;
    }

    public void visitSources(SCMSourceObserver observer) throws IOException, InterruptedException {
        TaskListener listener = observer.getListener();
        if (this.repoOwner.isEmpty()) {
            throw new AbortException("Must specify user or organization");
        }
        StandardCredentials credentials = Connector.lookupScanCredentials(observer.getContext(), this.apiUri, this.scanCredentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            github.checkApiUrlValidity();
        }
        catch (HttpException e) {
            String message = String.format("It seems %s is unreachable", this.apiUri == null ? "https://api.github.com" : this.apiUri);
            throw new AbortException(message);
        }
        if (credentials != null && !github.isCredentialValid()) {
            String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), this.apiUri == null ? "https://api.github.com" : this.apiUri);
            throw new AbortException(message);
        }
        if (!github.isAnonymous()) {
            listener.getLogger().format("Connecting to %s using %s%n", this.apiUri == null ? "https://api.github.com" : this.apiUri, CredentialsNameProvider.name((Credentials)credentials));
            GHMyself myself = null;
            try {
                myself = github.getMyself();
            }
            catch (RateLimitExceededException rle) {
                throw new AbortException(rle.getMessage());
            }
            if (myself != null && this.repoOwner.equalsIgnoreCase(myself.getLogin())) {
                listener.getLogger().format("Looking up repositories of myself %s%n%n", this.repoOwner);
                for (GHRepository repo : myself.listRepositories(100)) {
                    if (!repo.getOwnerName().equals(this.repoOwner)) continue;
                    this.add(listener, observer, repo);
                }
                return;
            }
        } else {
            listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.apiUri == null ? "https://api.github.com" : this.apiUri);
        }
        GHOrganization org = null;
        try {
            org = github.getOrganization(this.repoOwner);
        }
        catch (RateLimitExceededException rle) {
            throw new AbortException(rle.getMessage());
        }
        catch (FileNotFoundException rle) {
            // empty catch block
        }
        if (org != null && this.repoOwner.equalsIgnoreCase(org.getLogin())) {
            listener.getLogger().format("Looking up repositories of organization %s%n%n", this.repoOwner);
            for (GHRepository repo : org.listRepositories(100)) {
                this.add(listener, observer, repo);
            }
            return;
        }
        GHUser user = null;
        try {
            user = github.getUser(this.repoOwner);
        }
        catch (RateLimitExceededException rle) {
            throw new AbortException(rle.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (user != null && this.repoOwner.equalsIgnoreCase(user.getLogin())) {
            listener.getLogger().format("Looking up repositories of user %s%n%n", this.repoOwner);
            for (GHRepository repo : user.listRepositories(100)) {
                this.add(listener, observer, repo);
            }
            return;
        }
        throw new AbortException(this.repoOwner + " does not correspond to a known GitHub User Account or Organization");
    }

    private void add(TaskListener listener, SCMSourceObserver observer, GHRepository repo) throws InterruptedException {
        String name = repo.getName();
        if (!Pattern.compile(this.pattern).matcher(name).matches()) {
            listener.getLogger().format("Ignoring %s%n", name);
            return;
        }
        listener.getLogger().format("Proposing %s%n", name);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        SCMSourceObserver.ProjectObserver projectObserver = observer.observe(name);
        GitHubSCMSource ghSCMSource = new GitHubSCMSource(null, this.apiUri, this.checkoutCredentialsId, this.scanCredentialsId, this.repoOwner, name);
        ghSCMSource.setExcludes(this.getExcludes());
        ghSCMSource.setIncludes(this.getIncludes());
        ghSCMSource.setBuildOriginBranch(this.getBuildOriginBranch());
        ghSCMSource.setBuildOriginBranchWithPR(this.getBuildOriginBranchWithPR());
        ghSCMSource.setBuildOriginPRMerge(this.getBuildOriginPRMerge());
        ghSCMSource.setBuildOriginPRHead(this.getBuildOriginPRHead());
        ghSCMSource.setBuildForkPRMerge(this.getBuildForkPRMerge());
        ghSCMSource.setBuildForkPRHead(this.getBuildForkPRHead());
        projectObserver.addSource((SCMSource)ghSCMSource);
        projectObserver.complete();
    }

    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        public static final String defaultIncludes = "*";
        public static final String defaultExcludes = "";
        public static final String SAME = "SAME";
        public static final boolean defaultBuildOriginBranch = true;
        public static final boolean defaultBuildOriginBranchWithPR = true;
        public static final boolean defaultBuildOriginPRMerge = false;
        public static final boolean defaultBuildOriginPRHead = false;
        public static final boolean defaultBuildForkPRMerge = true;
        public static final boolean defaultBuildForkPRHead = false;
        @Inject
        private GitHubSCMSource.DescriptorImpl delegate;

        public String getDisplayName() {
            return Messages.GitHubSCMNavigator_DisplayName();
        }

        public String getDescription() {
            return Messages.GitHubSCMNavigator_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/github-branch-source/images/:size/github-scmnavigator.png";
        }

        public SCMNavigator newInstance(String name) {
            return new GitHubSCMNavigator(defaultExcludes, name, defaultExcludes, SAME);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckScanCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String scanCredentialsId, @QueryParameter String apiUri) {
            if (!scanCredentialsId.isEmpty()) {
                StandardCredentials credentials = Connector.lookupScanCredentials(context, apiUri, scanCredentialsId);
                if (credentials == null) {
                    return FormValidation.error((String)"Credentials not found");
                }
                try {
                    GitHub connector = Connector.connect(apiUri, credentials);
                    if (connector.isCredentialValid()) {
                        return FormValidation.ok();
                    }
                    return FormValidation.error((String)"Invalid credentials");
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception validating credentials " + CredentialsNameProvider.name((Credentials)credentials) + " on " + apiUri);
                    return FormValidation.error((String)"Exception validating credentials");
                }
            }
            return FormValidation.warning((String)"Credentials are recommended");
        }

        public ListBoxModel doFillScanCredentialsIdItems(@AncestorInPath SCMSourceOwner context) {
            StandardListBoxModel result = new StandardListBoxModel();
            result.withEmptySelection();
            Connector.fillScanCredentialsIdItems(result, context, null);
            return result;
        }

        public ListBoxModel doFillCheckoutCredentialsIdItems(@AncestorInPath SCMSourceOwner context) {
            StandardListBoxModel result = new StandardListBoxModel();
            result.add("- same as scan credentials -", SAME);
            result.add("- anonymous -", "ANONYMOUS");
            Connector.fillCheckoutCredentialsIdItems(result, context, null);
            return result;
        }

        public ListBoxModel doFillApiUriItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("GitHub", defaultExcludes);
            for (Endpoint e : GitHubConfiguration.get().getEndpoints()) {
                result.add(e.getName() == null ? e.getApiUri() : e.getName(), e.getApiUri());
            }
            return result;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckIncludes(@QueryParameter String value) {
            return this.delegate.doCheckIncludes(value);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildOriginBranchWithPR(@QueryParameter boolean buildOriginBranch, @QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead, @QueryParameter boolean buildForkPRMerge, @QueryParameter boolean buildForkPRHead) {
            return this.delegate.doCheckBuildOriginBranchWithPR(buildOriginBranch, buildOriginBranchWithPR, buildOriginPRMerge, buildOriginPRHead, buildForkPRMerge, buildForkPRHead);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildOriginPRHead(@QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead) {
            return this.delegate.doCheckBuildOriginPRHead(buildOriginBranchWithPR, buildOriginPRMerge, buildOriginPRHead);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildForkPRHead(@QueryParameter boolean buildOriginBranch, @QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead, @QueryParameter boolean buildForkPRMerge, @QueryParameter boolean buildForkPRHead) {
            return this.delegate.doCheckBuildForkPRHead(buildOriginBranch, buildOriginBranchWithPR, buildOriginPRMerge, buildOriginPRHead, buildForkPRMerge, buildForkPRHead);
        }
    }
}

