/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class GitHubConfiguration
extends GlobalConfiguration {
    private List<Endpoint> endpoints;

    public static GitHubConfiguration get() {
        return (GitHubConfiguration)((Object)GlobalConfiguration.all().get(GitHubConfiguration.class));
    }

    public GitHubConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    @NonNull
    public List<Endpoint> getEndpoints() {
        return this.endpoints == null ? Collections.emptyList() : Collections.unmodifiableList(this.endpoints);
    }

    public void setEndpoints(@CheckForNull List<Endpoint> endpoints) {
        endpoints = new ArrayList(endpoints == null ? Collections.emptyList() : endpoints);
        HashSet<String> apiUris = new HashSet<String>();
        Iterator<Endpoint> iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            Endpoint endpoint = iterator.next();
            if (endpoint.getApiUri() == null || apiUris.contains(endpoint.getApiUri())) {
                iterator.remove();
            }
            apiUris.add(endpoint.getApiUri());
        }
        this.endpoints = endpoints;
        this.save();
    }
}

