/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.QueueListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class GitHubBuildStatusNotification {
    private static final Logger LOGGER = Logger.getLogger(GitHubBuildStatusNotification.class.getName());

    private static void createCommitStatus(@Nonnull GHRepository repo, @Nonnull String revision, @Nonnull GHCommitState state, @Nonnull String url, @Nonnull String message, @Nonnull SCMHead head) throws IOException {
        LOGGER.log(Level.FINE, "{0}/commit/{1} {2} from {3}", new Object[]{repo.getHtmlUrl(), revision, state, url});
        String context = head instanceof PullRequestSCMHead ? (((PullRequestSCMHead)head).isMerge() ? "continuous-integration/jenkins/pr-merge" : "continuous-integration/jenkins/pr-head") : "continuous-integration/jenkins/branch";
        repo.createCommitStatus(revision, state, url, message, context);
    }

    private static void createBuildCommitStatus(Run<?, ?> build, TaskListener listener) {
        block14: {
            try {
                SCMRevisionAction action;
                GHRepository repo = GitHubBuildStatusNotification.lookUpRepo(build.getParent());
                if (repo == null || (action = (SCMRevisionAction)build.getAction(SCMRevisionAction.class)) == null) break block14;
                SCMRevision revision = action.getRevision();
                String url = DisplayURLProvider.get().getRunURL(build);
                boolean ignoreError = false;
                try {
                    Result result = build.getResult();
                    String revisionToNotify = GitHubBuildStatusNotification.resolveHeadCommit(repo, revision);
                    SCMHead head = revision.getHead();
                    if (Result.SUCCESS.equals(result)) {
                        GitHubBuildStatusNotification.createCommitStatus(repo, revisionToNotify, GHCommitState.SUCCESS, url, Messages.GitHubBuildStatusNotification_CommitStatus_Good(), head);
                    } else if (Result.UNSTABLE.equals(result)) {
                        GitHubBuildStatusNotification.createCommitStatus(repo, revisionToNotify, GHCommitState.FAILURE, url, Messages.GitHubBuildStatusNotification_CommitStatus_Unstable(), head);
                    } else if (Result.FAILURE.equals(result)) {
                        GitHubBuildStatusNotification.createCommitStatus(repo, revisionToNotify, GHCommitState.FAILURE, url, Messages.GitHubBuildStatusNotification_CommitStatus_Failure(), head);
                    } else if (result != null) {
                        GitHubBuildStatusNotification.createCommitStatus(repo, revisionToNotify, GHCommitState.ERROR, url, Messages.GitHubBuildStatusNotification_CommitStatus_Other(), head);
                    } else {
                        ignoreError = true;
                        GitHubBuildStatusNotification.createCommitStatus(repo, revisionToNotify, GHCommitState.PENDING, url, Messages.GitHubBuildStatusNotification_CommitStatus_Pending(), head);
                    }
                    if (result != null) {
                        listener.getLogger().format("%n" + Messages.GitHubBuildStatusNotification_CommitStatusSet() + "%n%n", new Object[0]);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (!ignoreError) {
                        listener.getLogger().format("%nCould not update commit status, please check if your scan credentials belong to a member of the organization or a collaborator of the repository and repo:status scope is selected%n%n", new Object[0]);
                        LOGGER.log(Level.FINE, null, fnfe);
                    }
                }
            }
            catch (IOException ioe) {
                listener.getLogger().format("%nCould not update commit status. Message: %s%n%n", ioe.getMessage());
                LOGGER.log(Level.FINE, "Could not update commit status", ioe);
            }
        }
    }

    @CheckForNull
    private static GHRepository lookUpRepo(@Nonnull Job<?, ?> job) throws IOException {
        SCMSourceOwner scmSourceOwner;
        GitHubSCMSource source;
        ItemGroup multiBranchProject = job.getParent();
        if (multiBranchProject instanceof SCMSourceOwner && (source = GitHubBuildStatusNotification.getSCMSource(scmSourceOwner = (SCMSourceOwner)multiBranchProject)) != null && source.getScanCredentialsId() != null) {
            GitHub github = Connector.connect(source.getApiUri(), Connector.lookupScanCredentials(scmSourceOwner, null, source.getScanCredentialsId()));
            return github.getRepository(source.getRepoOwner() + "/" + source.getRepository());
        }
        return null;
    }

    @CheckForNull
    private static GitHubSCMSource getSCMSource(SCMSourceOwner scmSourceOwner) {
        for (SCMSource scmSource : scmSourceOwner.getSCMSources()) {
            if (!(scmSource instanceof GitHubSCMSource)) continue;
            return (GitHubSCMSource)scmSource;
        }
        return null;
    }

    private static String resolveHeadCommit(GHRepository repo, SCMRevision revision) throws IllegalArgumentException {
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            return ((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash();
        }
        if (revision instanceof PullRequestSCMRevision) {
            return ((PullRequestSCMRevision)revision).getPullHash();
        }
        throw new IllegalArgumentException("did not recognize " + revision);
    }

    private GitHubBuildStatusNotification() {
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, TaskListener listener) {
            GitHubBuildStatusNotification.createBuildCommitStatus(build, listener);
        }
    }

    @Extension
    public static class JobCheckOutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            GitHubBuildStatusNotification.createBuildCommitStatus(build, listener);
        }
    }

    @Extension
    public static class PRJobScheduledListener
    extends QueueListener {
        public void onEnterWaiting(Queue.WaitingItem wi) {
            Job job;
            SCMHead head;
            if (wi.task instanceof Job && (head = SCMHead.HeadByItem.findHead((Item)(job = (Job)wi.task))) instanceof PullRequestSCMHead) {
                try {
                    GHRepository repo = GitHubBuildStatusNotification.lookUpRepo(job);
                    if (repo != null) {
                        int number = ((PullRequestSCMHead)head).getNumber();
                        GHPullRequest pr = repo.getPullRequest(number);
                        String url = DisplayURLProvider.get().getJobURL(job);
                        GitHubBuildStatusNotification.createCommitStatus(repo, pr.getHead().getSha(), GHCommitState.PENDING, url, Messages.GitHubBuildStatusNotification_CommitStatus_Queued(), head);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    LOGGER.log(Level.WARNING, "Could not update commit status to PENDING. Valid scan credentials? Valid scopes?");
                    LOGGER.log(Level.FINE, null, fnfe);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Could not update commit status to PENDING. Message: " + ioe.getMessage());
                    LOGGER.log(Level.FINE, null, ioe);
                }
            }
        }
    }
}

