/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.fasterxml.jackson.core.JsonParseException;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Endpoint
extends AbstractDescribableImpl<Endpoint> {
    private final String name;
    private final String apiUri;

    @DataBoundConstructor
    public Endpoint(String apiUri, String name) {
        this.apiUri = Util.fixEmptyAndTrim((String)apiUri);
        this.name = Util.fixEmptyAndTrim((String)name);
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Endpoint{");
        sb.append("apiUrl='").append(this.apiUri).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)((Object)o);
        return !(this.apiUri != null ? !this.apiUri.equals(endpoint.apiUri) : endpoint.apiUri != null);
    }

    public int hashCode() {
        return this.apiUri != null ? this.apiUri.hashCode() : 0;
    }

    @Extension
    public static class DesciptorImpl
    extends Descriptor<Endpoint> {
        private static final Logger LOGGER = Logger.getLogger(DesciptorImpl.class.getName());

        public String getDisplayName() {
            return "";
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckApiUri(@QueryParameter String apiUri) {
            if (Util.fixEmptyAndTrim((String)apiUri) == null) {
                return FormValidation.warning((String)"You must specify the API URL");
            }
            try {
                URL api = new URL(apiUri);
                GitHub github = GitHub.connectToEnterpriseAnonymously((String)api.toString());
                github.checkApiUrlValidity();
                LOGGER.log(Level.FINE, "Trying to configure a GitHub Enterprise server");
                return FormValidation.ok((String)"GitHub Enterprise server verified");
            }
            catch (MalformedURLException mue) {
                LOGGER.log(Level.WARNING, "Trying to configure a GitHub Enterprise server: " + apiUri, mue.getCause());
                return FormValidation.error((String)"The endpoint does not look like a GitHub Enterprise (malformed URL)");
            }
            catch (JsonParseException jpe) {
                LOGGER.log(Level.WARNING, "Trying to configure a GitHub Enterprise server: " + apiUri, jpe.getCause());
                return FormValidation.error((String)"The endpoint does not look like a GitHub Enterprise (invalid JSON response)");
            }
            catch (FileNotFoundException fnt) {
                LOGGER.log(Level.WARNING, "Getting HTTP Error 404 for " + apiUri);
                return FormValidation.error((String)"The endpoint does not look like a GitHub Enterprise (page not found");
            }
            catch (IOException e) {
                if (e.getMessage().contains("private mode enabled")) {
                    LOGGER.log(Level.FINE, e.getMessage());
                    return FormValidation.warning((String)"Private mode enabled, validation disabled");
                }
                LOGGER.log(Level.WARNING, e.getMessage());
                return FormValidation.error((String)"The endpoint does not look like a GitHub Enterprise (verify network and/or try again later)");
            }
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckName(@QueryParameter String name) {
            if (Util.fixEmptyAndTrim((String)name) == null) {
                return FormValidation.warning((String)"You must specify the name");
            }
            return FormValidation.ok();
        }
    }
}

