/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubWebHook;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.hash.Hashing;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import hudson.Util;
import hudson.model.Item;
import hudson.security.ACL;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.extras.OkHttpConnector;

public class Connector {
    public static final RateLimitHandler CUSTOMIZED = new RateLimitHandler(){

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            try {
                long limit = Long.parseLong(uc.getHeaderField("X-RateLimit-Limit"));
                long remaining = Long.parseLong(uc.getHeaderField("X-RateLimit-Remaining"));
                long reset = Long.parseLong(uc.getHeaderField("X-RateLimit-Reset"));
                throw new RateLimitExceededException("GitHub API rate limit exceeded", limit, remaining, reset);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe);
            }
        }
    };

    @CheckForNull
    public static StandardCredentials lookupScanCredentials(@CheckForNull SCMSourceOwner context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId) {
        if (Util.fixEmpty((String)scanCredentialsId) == null) {
            return null;
        }
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Connector.githubDomainRequirements(apiUri)), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scanCredentialsId), Connector.githubScanCredentialsMatcher()}));
    }

    @Nonnull
    public static GitHub connect(@CheckForNull String apiUri, @CheckForNull StandardCredentials credentials) throws IOException {
        String host;
        String apiUrl = Util.fixEmptyAndTrim((String)apiUri);
        try {
            apiUrl = apiUrl != null ? apiUrl : "https://api.github.com";
            host = new URL(apiUrl).getHost();
        }
        catch (MalformedURLException e) {
            throw new IOException("Invalid GitHub API URL: " + apiUrl, e);
        }
        GitHubBuilder gb = new GitHubBuilder();
        gb.withEndpoint(apiUrl);
        gb.withRateLimitHandler(CUSTOMIZED);
        OkHttpClient client = new OkHttpClient().setProxy(Connector.getProxy(host));
        gb.withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(client)));
        if (credentials != null) {
            if (credentials instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)credentials;
                gb.withPassword(c.getUsername(), c.getPassword().getPlainText());
            } else {
                throw new IOException("Unsupported credential type: " + credentials.getClass().getName());
            }
        }
        return gb.build();
    }

    public static void fillScanCredentialsIdItems(StandardListBoxModel result, @CheckForNull SCMSourceOwner context, @CheckForNull String apiUri) {
        result.withMatching(Connector.githubScanCredentialsMatcher(), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Connector.githubDomainRequirements(apiUri)));
    }

    public static void fillCheckoutCredentialsIdItems(StandardListBoxModel result, @CheckForNull SCMSourceOwner context, @CheckForNull String apiUri) {
        result.withMatching(GitClient.CREDENTIALS_MATCHER, (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Connector.githubDomainRequirements(apiUri)));
    }

    private static CredentialsMatcher githubScanCredentialsMatcher() {
        return CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});
    }

    private static List<DomainRequirement> githubDomainRequirements(String apiUri) {
        return URIRequirementBuilder.fromUri((String)StringUtils.defaultIfEmpty((String)apiUri, (String)"https://github.com")).build();
    }

    @Nonnull
    private static Proxy getProxy(@Nonnull String host) {
        Jenkins jenkins = GitHubWebHook.getJenkinsInstance();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        return jenkins.proxy.createProxy(host);
    }

    private static String hashed(GitHubServerConfig config) {
        return Hashing.murmur3_32().newHasher().putString((CharSequence)org.apache.commons.lang3.StringUtils.trimToEmpty((String)config.getApiUrl())).putString((CharSequence)org.apache.commons.lang3.StringUtils.trimToEmpty((String)config.getCredentialsId())).hash().toString();
    }

    private Connector() {
    }
}

