function obterRecursosNecessarios() {

    $recursos = 
    "IIS-WebServerRole",
    "IIS-ApplicationDevelopment",
    "IIS-WebServer",
    "IIS-DefaultDocument",
    "IIS-DirectoryBrowsing",
    "IIS-HttpErrors",
    "IIS-StaticContent",
    'IIS-CustomLogging',
    "IIS-CustomLogging",
    "IIS-HttpCompressionStatic",
    "IIS-HttpCompressionDynamic",
    "IIS-RequestFiltering",
    "IIS-BasicAuthentication",
    "IIS-CertProvider",
    "IIS-ClientCertificateMappingAuthentication",
    "IIS-DigestAuthentication",
    "IIS-ClientCertificateMappingAuthentication",
    "IIS-Security",
    "IIS-WindowsAuthentication",
    "NetFx4Extended-ASPNET45",
    "IIS-ASPNET45",
    "IIS-ISAPIExtensions",
    "IIS-ISAPIFilter",
    "IIS-ManagementConsole",
    "IIS-ManagementScriptingTools",
    "IIS-ManagementService",
    "WCF-TCP-PortSharing45",
    "IIS-ApplicationInit",
    "IIS-NetFxExtensibility45",
    "Microsoft-Hyper-V",
    "containers",
    "IIS-WebSockets"
    

    $recursos
    
}
function instalarRecurso() {
    param(
        [Parameter(Mandatory = $true)]
        $nome
    )

    Write-Host "Instalando recurso $nome"

    Enable-WindowsOptionalFeature -Online -FeatureName $nome -All -NoRestart

}

$ErrorActionPreference = 'Continue'

$recursos = (obterRecursosNecessarios)

foreach($recurso in $recursos) {
    instalarRecurso -nome $recurso
}

