if NOT exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[RATEIOHORARIO]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
   CREATE TABLE RATEIOHORARIO(
          RCLIENTE int not null,
          DATA datetime,
          PERCENTUAL float)
go
truncate table RATEIOHORARIO
go

INSERT INTO RATEIOHORARIO
SELECT FH3.CLIENTE, FH3.DATA, ROUND(SUM(FH3.PERCENTUAL),2)
FROM (SELECT FH.RPESSOA CLIENTE,CAST(YEAR(FH.DATA) AS VARCHAR)+'-'+CAST(MONTH(FH.DATA) AS VARCHAR)+'-01' DATA, FH.RFUNCIONARIO,
(SUM(FH.HORASTRABALHADAS* VF.VALOR )/FH2.TOTAL * 100) PERCENTUAL
FROM BDSICAP..FOLHADEHORARIO FH, BDSICAP..VALORFUNCIONARIO VF ,(SELECT YEAR(FH1.DATA) ANO,MONTH(FH1.DATA) MES, SUM(FH1.HORASTRABALHADAS*VF1.VALOR) TOTAL
	FROM BDSICAP..FOLHADEHORARIO FH1, BDSICAP..VALORFUNCIONARIO VF1
        WHERE
	   FH1.RFUNCIONARIO = VF1.RFUNCIONARIO AND
	   MONTH(FH1.DATA) = MONTH(VF1.PERIODO) AND
	   YEAR(FH1.DATA) = YEAR(VF1.PERIODO)
	GROUP BY YEAR(FH1.DATA), MONTH(FH1.DATA)) FH2
WHERE 
FH.RFUNCIONARIO = VF.RFUNCIONARIO AND
MONTH(FH.DATA) = MONTH(VF.PERIODO) AND
YEAR(FH.DATA) = YEAR(VF.PERIODO) AND
MONTH(FH.DATA) = FH2.MES AND
YEAR(FH.DATA) = FH2.ANO
GROUP BY CAST(YEAR(FH.DATA) AS VARCHAR)+'-'+CAST(MONTH(FH.DATA) AS VARCHAR)+'-01', FH.RPESSOA, FH.RFUNCIONARIO, VF.VALOR, FH2.TOTAL) FH3
GROUP BY FH3.CLIENTE, FH3.DATA

--Faturado
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,FATURA.EMISSAO,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,FATURA.EMISSAO,103),4,2) + SUBSTRING(CONVERT(VARCHAR,FATURA.EMISSAO,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '01',
         CONVERT(DATETIME, FATURA.EMISSAO) ,
         DATEPART(DW,CONVERT(DATETIME,FATURA.EMISSAO )),
         ISNULL(SUM(CONVERT(FLOAT, FATURA.VALORNAMOEDA1)),0), 0,0,0,0,0,0,0,0,0
FROM    BDSICAP..DOCDEORIGEM_R FATURA, BDSICAP..CLASSIFICACAO CLASSIFICACAO, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO
WHERE 
       FATURA.OID > 7 AND 
       CLASSIFICACAO.RITEM = FATURA.OID AND
       SUBGRUPO.RITEM = FATURA.RDESTINATARIO AND
       SUBGRUPO.RCATEGORIA <> 2121 AND
       GRUPO.OID = SUBGRUPO.RCATEGORIA AND
       CLASSIFICACAO.RCATEGORIA = 2473 AND
       FATURA.EMISSAO IS NOT NULL AND
       FATURA.RSITUACAO <> 2348 AND
       FATURA.RTIPO = 11669
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,FATURA.EMISSAO,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,FATURA.EMISSAO,103),4,2) + SUBSTRING(CONVERT(VARCHAR,FATURA.EMISSAO,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, FATURA.EMISSAO) ,
         DATEPART(DW,CONVERT(DATETIME,FATURA.EMISSAO ))

-- Receita Comisso
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '02',
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA )),
         0,
         ISNULL(SUM(CONVERT(FLOAT, ATENDEPEDIDO.VALORUNITARIO)),0), 0,0,0,0,0,0,0,0
FROM    BDSICAP..DOCDEORIGEM_R FATURA, BDSICAP..CLASSIFICACAO CLASSIFICACAO, BDSICAP..ATENDEPEDIDO ATENDEPEDIDO, BDSICAP..DETALHEDENOTA DETALHEDENOTA, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO, BDSICAP..CONTAARECEBER CONTAARECEBER, BDSICAP..ACAOFINANCEIRA ACAOFINANCEIRA, BDSICAP..ATOFINANCEIRO ATOFINANCEIRO
WHERE 
	FATURA.OID > 7 AND 
        CONTAARECEBER.RDOCDEORIGEM = FATURA.OID AND
	CLASSIFICACAO.RITEM = FATURA.OID AND
        ACAOFINANCEIRA.RCONTA = CONTAARECEBER.OID AND
        ACAOFINANCEIRA.RATOFINANCEIRO = ATOFINANCEIRO.OID AND
        ATOFINANCEIRO.RTIPO IN(2372,2718,8127,16986,18651,20669) AND
        ATOFINANCEIRO.RESTORNO = 7 AND
        SUBGRUPO.RITEM = FATURA.RDESTINATARIO AND
        SUBGRUPO.RCATEGORIA <> 2121 AND
        GRUPO.OID = SUBGRUPO.RCATEGORIA AND
        CLASSIFICACAO.RCATEGORIA = 2473 AND
        ATENDEPEDIDO.TIPO = '21' AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
	FATURA.EMISSAO IS NOT NULL AND
        ATOFINANCEIRO.DATA IS NOT NULL AND
        FATURA.RSITUACAO <> 2348 AND
        FATURA.RTIPO = 11669
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA ))
go

-- Receita Trabalho Interno
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '03',
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA )),
         0,
         ISNULL(SUM(CONVERT(FLOAT, ATENDEPEDIDO.VALORUNITARIO)),0), 0,0,0,0,0,0,0,0
FROM    BDSICAP..DOCDEORIGEM_R FATURA, BDSICAP..CLASSIFICACAO CLASSIFICACAO, BDSICAP..ATENDEPEDIDO ATENDEPEDIDO, BDSICAP..DETALHEDENOTA DETALHEDENOTA, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO, BDSICAP..CONTAARECEBER CONTAARECEBER, BDSICAP..ACAOFINANCEIRA ACAOFINANCEIRA, BDSICAP..ATOFINANCEIRO ATOFINANCEIRO, BDSICAP..TRABALHOINTERNO TRABALHO, BDSICAP..ACORDODEPRECO ACORDODEPRECO
WHERE 
	FATURA.OID > 7 AND 
        CONTAARECEBER.RDOCDEORIGEM = FATURA.OID AND
	CLASSIFICACAO.RITEM = FATURA.OID AND
        ACAOFINANCEIRA.RCONTA = CONTAARECEBER.OID AND
        ACAOFINANCEIRA.RATOFINANCEIRO = ATOFINANCEIRO.OID AND
        ATOFINANCEIRO.RTIPO IN(2372,2718,8127,16986,18651,20669) AND
        ATOFINANCEIRO.RESTORNO = 7 AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
        ATENDEPEDIDO.RITEM = TRABALHO.OID AND
	ACORDODEPRECO.RGRUPO = TRABALHO.OID AND
        SUBGRUPO.RITEM = FATURA.RDESTINATARIO AND
        SUBGRUPO.RCATEGORIA <> 2121 AND
        GRUPO.OID = SUBGRUPO.RCATEGORIA AND
        CLASSIFICACAO.RCATEGORIA = 2473 AND
        ATENDEPEDIDO.TIPO = '20' AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
	FATURA.EMISSAO IS NOT NULL AND
        ATOFINANCEIRO.DATA IS NOT NULL AND
        FATURA.RSITUACAO <> 2348 AND
        FATURA.RTIPO = 11669
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA ))
go

-- Receita Trabalho Especial
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '04',
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA )),
         0,
         ISNULL(SUM(CONVERT(FLOAT, ATENDEPEDIDO.VALORUNITARIO)),0), 0,0,0,0,0,0,0,0
FROM    BDSICAP..DOCDEORIGEM_R FATURA, BDSICAP..CLASSIFICACAO CLASSIFICACAO, BDSICAP..ATENDEPEDIDO ATENDEPEDIDO, BDSICAP..DETALHEDENOTA DETALHEDENOTA, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO, BDSICAP..CONTAARECEBER CONTAARECEBER, BDSICAP..ACAOFINANCEIRA ACAOFINANCEIRA, BDSICAP..ATOFINANCEIRO ATOFINANCEIRO, BDSICAP..TRABALHOESPECIAL TRABALHO, BDSICAP..ACORDODEPRECO ACORDODEPRECO
WHERE 
	FATURA.OID > 7 AND 
        CONTAARECEBER.RDOCDEORIGEM = FATURA.OID AND
	CLASSIFICACAO.RITEM = FATURA.OID AND
        ACAOFINANCEIRA.RCONTA = CONTAARECEBER.OID AND
        ACAOFINANCEIRA.RATOFINANCEIRO = ATOFINANCEIRO.OID AND
        ATOFINANCEIRO.RTIPO IN(2372,2718,8127,16986,18651,20669) AND
        ATOFINANCEIRO.RESTORNO = 7 AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
        ATENDEPEDIDO.RITEM = TRABALHO.OID AND
	ACORDODEPRECO.RGRUPO = TRABALHO.OID AND
        SUBGRUPO.RITEM = FATURA.RDESTINATARIO AND
        SUBGRUPO.RCATEGORIA <> 2121 AND
        GRUPO.OID = SUBGRUPO.RCATEGORIA AND
        CLASSIFICACAO.RCATEGORIA = 2473 AND
        ATENDEPEDIDO.TIPO = '20' AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
	FATURA.EMISSAO IS NOT NULL AND
        ATOFINANCEIRO.DATA IS NOT NULL AND
        FATURA.RSITUACAO <> 2348 AND
        FATURA.RTIPO = 11669
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA ))
go

-- Receita BV
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '05',
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA )),
         0,0,
         ISNULL(SUM(CONVERT(FLOAT, ATENDEPEDIDO.VALORUNITARIO)),0), 0,0,0,0,0,0,0
FROM    BDSICAP..DOCDEORIGEM_R FATURA, BDSICAP..CLASSIFICACAO CLASSIFICACAO, BDSICAP..ATENDEPEDIDO ATENDEPEDIDO, BDSICAP..DETALHEDENOTA DETALHEDENOTA, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO, BDSICAP..CONTAARECEBER CONTAARECEBER, BDSICAP..ACAOFINANCEIRA ACAOFINANCEIRA, BDSICAP..ATOFINANCEIRO ATOFINANCEIRO, BDSICAP..TRABALHOESPECIAL TRABALHO, BDSICAP..ACORDODEPRECO ACORDODEPRECO, BDSICAP..CLASSIFICACAO CLTRABALHO
WHERE 
	FATURA.OID > 7 AND 
        CONTAARECEBER.RDOCDEORIGEM = FATURA.OID AND
	CLASSIFICACAO.RITEM = FATURA.OID AND
        ACAOFINANCEIRA.RCONTA = CONTAARECEBER.OID AND
        ACAOFINANCEIRA.RATOFINANCEIRO = ATOFINANCEIRO.OID AND
        ATOFINANCEIRO.RTIPO IN(2372,2718,8127,16986,18651,20669) AND
        ATOFINANCEIRO.RESTORNO = 7 AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
        ATENDEPEDIDO.RITEM = TRABALHO.OID AND
	ACORDODEPRECO.RGRUPO = TRABALHO.OID AND
        CLTRABALHO.RITEM = TRABALHO.OID AND
        CLTRABALHO.RCATEGORIA IN(1037,13500) AND
        SUBGRUPO.RITEM = FATURA.RDESTINATARIO AND
        SUBGRUPO.RCATEGORIA <> 2121 AND
        GRUPO.OID = SUBGRUPO.RCATEGORIA AND
        CLASSIFICACAO.RCATEGORIA = 2473 AND
        DETALHEDENOTA.RDOCDEORIGEM = FATURA.OID AND
        ATENDEPEDIDO.RDETALHEDENOTA = DETALHEDENOTA.OID AND
	FATURA.EMISSAO IS NOT NULL AND
        FATURA.RSITUACAO <> 2348 AND
        FATURA.RTIPO = 11669
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( FATURA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA ))
go

--DESPESAS OPERACIONAIS
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( RATEIOHORARIO.RCLIENTE )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '06',
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA )),
         0,0,0,
         ISNULL(SUM(CONVERT(FLOAT, CONTAAPAGAR.VALORNAMOEDA1*(RATEIOHORARIO.PERCENTUAL/100))),0), 0,0,0,0,0,0
FROM     BDSICAP..CONTAAPAGAR_R CONTAAPAGAR, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO, BDSICAP..ACAOFINANCEIRA ACAOFINANCEIRA, BDSICAP..ATOFINANCEIRO ATOFINANCEIRO, RATEIOHORARIO RATEIOHORARIO, BDSICAP..TPO_R TPO
WHERE 
	CONTAAPAGAR.OID > 7 AND 
        ACAOFINANCEIRA.RCONTA = CONTAAPAGAR.OID AND
        ACAOFINANCEIRA.RATOFINANCEIRO = ATOFINANCEIRO.OID AND
        ATOFINANCEIRO.RTIPO IN(2372,2718,8127,16986,18651,20669) AND
        ATOFINANCEIRO.RESTORNO = 7 AND
        MONTH(RATEIOHORARIO.DATA) = MONTH(ATOFINANCEIRO.DATA) AND
        YEAR(RATEIOHORARIO.DATA) = YEAR(ATOFINANCEIRO.DATA) AND
        SUBGRUPO.RITEM = RATEIOHORARIO.RCLIENTE AND
        SUBGRUPO.RCATEGORIA <> 2121 AND
        GRUPO.OID = SUBGRUPO.RCATEGORIA AND
        RATEIOHORARIO.PERCENTUAL > 0 AND
        TPO.OID = CONTAAPAGAR.RTPO AND
        TPO.RESCOPO IN( 2013151, 2013154, 2034156, 2035292, 2035322, 2035358)
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( RATEIOHORARIO.RCLIENTE )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA ))
go
--DESPESAS PESSOAL
INSERT INTO NIVEL4RAT
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( RATEIOHORARIO.RCLIENTE )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         '07',
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA )),
         0,0,0,0,
         ISNULL(SUM(CONVERT(FLOAT, CONTAAPAGAR.VALORNAMOEDA1*(RATEIOHORARIO.PERCENTUAL/100))),0), 0,0,0,0,0
FROM     BDSICAP..CONTAAPAGAR_R CONTAAPAGAR, BDSICAP..CLASSIFICACAO SUBGRUPO, BDSICAP..CATEGORIA_R GRUPO, BDSICAP..ACAOFINANCEIRA ACAOFINANCEIRA, BDSICAP..ATOFINANCEIRO ATOFINANCEIRO, RATEIOHORARIO RATEIOHORARIO, BDSICAP..TPO_R TPO
WHERE 
	CONTAAPAGAR.OID > 7 AND 
        ACAOFINANCEIRA.RCONTA = CONTAAPAGAR.OID AND
        ACAOFINANCEIRA.RATOFINANCEIRO = ATOFINANCEIRO.OID AND
        ATOFINANCEIRO.RTIPO IN(2372,2718,8127,16986,18651,20669) AND
        ATOFINANCEIRO.RESTORNO = 7 AND
        MONTH(RATEIOHORARIO.DATA) = MONTH(ATOFINANCEIRO.DATA) AND
        YEAR(RATEIOHORARIO.DATA) = YEAR(ATOFINANCEIRO.DATA) AND
        SUBGRUPO.RITEM = RATEIOHORARIO.RCLIENTE AND
        SUBGRUPO.RCATEGORIA <> 2121 AND
        GRUPO.OID = SUBGRUPO.RCATEGORIA AND
        RATEIOHORARIO.PERCENTUAL > 0 AND
        TPO.OID = CONTAAPAGAR.RTPO AND
        TPO.RESCOPO = 2013148
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( RATEIOHORARIO.RCLIENTE )),10), 
         SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,ATOFINANCEIRO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( GRUPO.RSUPER )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( SUBGRUPO.RCATEGORIA )),10),
         CONVERT(DATETIME, ATOFINANCEIRO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,ATOFINANCEIRO.DATA ))
go

INSERT INTO nivel3RAT SELECT NIVEL3, NIVEL1, NIVEL2, DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel4RAT
                      GROUP BY NIVEL3, NIVEL1, NIVEL2, DATA, DIASEM;
GO

INSERT INTO nivel2RAT SELECT NIVEL2, NIVEL1, DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel3RAT
                      GROUP BY NIVEL2, NIVEL1, DATA, DIASEM;
GO

INSERT INTO nivel1RAT SELECT NIVEL1, DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel2RAT
                      GROUP BY NIVEL1, DATA, DIASEM;
GO

INSERT INTO TAB_NIVEL1RAT (NIVEL1, DESCRICAO) SELECT DISTINCT NIVEL1, 'DATA ' + NIVEL1 
                          FROM nivel1RAT
                          WHERE NOT EXISTS (SELECT NIVEL1 FROM TAB_NIVEL1RAT WHERE
                          TAB_NIVEL1RAT.NIVEL1=NIVEL1RAT.NIVEL1)
GO
INSERT INTO TAB_NIVEL2RAT (NIVEL2, DESCRICAO) SELECT DISTINCT NIVEL2, 'GRUPO ' + NIVEL2
                          FROM nivel2RAT
                          WHERE NOT EXISTS (SELECT NIVEL2 FROM TAB_NIVEL2RAT WHERE
                          TAB_NIVEL2RAT.NIVEL2=NIVEL2RAT.NIVEL2)
GO
INSERT INTO TAB_NIVEL3RAT (NIVEL3, DESCRICAO) SELECT DISTINCT NIVEL3, 'SUBGRUPO ' + NIVEL3
                          FROM nivel3RAT
                          WHERE NOT EXISTS (SELECT NIVEL3 FROM TAB_NIVEL3RAT WHERE
                          TAB_NIVEL3RAT.NIVEL3=NIVEL3RAT.NIVEL3)
GO
INSERT INTO TAB_NIVEL4RAT (NIVEL4, DESCRICAO) SELECT DISTINCT NIVEL4, 'CLIENTE ' + NIVEL4
                          FROM nivel4RAT
                          WHERE NOT EXISTS (SELECT NIVEL4 FROM TAB_NIVEL4RAT WHERE
                          TAB_NIVEL4RAT.NIVEL4=NIVEL4RAT.NIVEL4)
GO

UPDATE TAB_NIVEL1RAT SET MES      = SUBSTRING ( NIVEL1,5,2) + '/' + LEFT(NIVEL1,4),
		      BIMESTRE = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '05' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '05' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '06' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '06' +  '/' + LEFT(NIVEL1,4)
			END,
		      TRIMESTRE = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '04' +  '/' + LEFT(NIVEL1,4)
			END,
		      QUADRIMESTRE  = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '03' +  '/' + LEFT(NIVEL1,4)
			END,
		      SEMESTRE  = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '02' +  '/' + LEFT(NIVEL1,4)
			END,
			ANO = LEFT(NIVEL1,4),
		      DIAUTIL  = CASE DATEPART(DW,CONVERT(DATETIME,NIVEL1)) 
                      WHEN '1' THEN 'N'
                      WHEN '2' THEN 'S' 
                      WHEN '3' THEN 'S' 
                      WHEN '4' THEN 'S' 
                      WHEN '5' THEN 'S' 
                      WHEN '6' THEN 'S' 
                      WHEN '7' THEN 'N' 
			END
GO
UPDATE TAB_NIVEL2RAT SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL2RAT, BDSICAP..ITEM
           WHERE NIVEL2 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO
UPDATE TAB_NIVEL3RAT SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL3RAT, BDSICAP..ITEM
           WHERE NIVEL3 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO
UPDATE TAB_NIVEL4RAT SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL4RAT, BDSICAP..ITEM
           WHERE NIVEL4 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO