INSERT INTO NIVEL5FSC
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( CONTA.REMITENTE )),10), 
         SUBSTRING(CONVERT(VARCHAR,CONTA.EMISSAO,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,CONTA.EMISSAO,103),4,2) + SUBSTRING(CONVERT(VARCHAR,CONTA.EMISSAO,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RDESTINATARIO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RPORTADOR )),10),
         '01',
         CONVERT(DATETIME, CONTA.EMISSAO) ,
         DATEPART(DW,CONVERT(DATETIME,CONTA.EMISSAO)),
         0,         
         ISNULL(SUM(CONVERT(FLOAT, CONTA.VALORNAMOEDA1)),0), 0,0,0,0,0,0,0,0
FROM    BDSICAP..CONTAARECEBER_R CONTA
WHERE 
	CONTA.OID > 7 AND EMISSAO IS NOT NULL
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.REMITENTE )),10), 
         SUBSTRING(CONVERT(VARCHAR,CONTA.EMISSAO,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,CONTA.EMISSAO,103),4,2) + SUBSTRING(CONVERT(VARCHAR,CONTA.EMISSAO,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RDESTINATARIO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RPORTADOR )),10),
         CONVERT(DATETIME, CONTA.EMISSAO) ,
         DATEPART(DW,CONVERT(DATETIME,CONTA.EMISSAO))
INSERT INTO NIVEL5FSC
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( CAIXA.RITEM )),10), 
         SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTIPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RFONTEPAGADORA )),10),
         '03',
         CONVERT(DATETIME, FATO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,FATO.DATA)),
         0,         
         ISNULL(SUM(CONVERT(FLOAT, FATO.VALOR)),0), 0,0,0,0,0,0,0,0
FROM    BDSICAP..FATOFINANCEIRO_R FATO, BDSICAP..CAIXABANCARIA_R CAIXA
WHERE 
        FATO.RFONTEPAGADORA = CAIXA.OID AND
	FATO.OID > 7 AND DATA IS NOT NULL AND FATO.RATOFINANCEIRO = 7 AND SINAL = 1
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( CAIXA.RITEM )),10), 
         SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTIPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RFONTEPAGADORA )),10),
         CONVERT(DATETIME, FATO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,FATO.DATA))

INSERT INTO NIVEL5FSC
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,CONTA.CHEGADA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,CONTA.CHEGADA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,CONTA.CHEGADA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.REMITENTE )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RPORTADOR )),10),
         '02',
         CONVERT(DATETIME, CONTA.CHEGADA) ,
         DATEPART(DW,CONVERT(DATETIME,CONTA.CHEGADA)),
         ISNULL(SUM(CONVERT(FLOAT, CONTA.VALORNAMOEDA1)),0),
         0,
         0,0,0,0,0,0,0,0
FROM    BDSICAP..CONTAAPAGAR_R CONTA
WHERE 
	CONTA.OID > 7 AND CHEGADA IS NOT NULL AND RTPO > 7 AND REMITENTE > 7 AND
        NOT EXISTS (SELECT 1 FROM BDSICAP..VINCULAPAGAMENTO WHERE OID > 7 AND RNOTAFORNECEDOR > 7 AND CONTA.RDOCDEORIGEM=RNOTAFORNECEDOR )  AND
        NOT EXISTS(SELECT 1 FROM BDSICAP..VINCULAPAGAMENTO WHERE OID > 7 AND RNOTAFORNECEDOR > 7 AND CONTA.OID=RNOTAFORNECEDOR) AND 
        NOT EXISTS(SELECT 1 FROM BDSICAP..CONTAAPAGAR_R CP, BDSICAP..VINCULAPAGAMENTO V WHERE CONTA.RDOCDEORIGEM = CP.OID AND CP.RDOCDEORIGEM = V.RNOTAFORNECEDOR AND V.OID > 7 AND V.RNOTAFORNECEDOR > 7)
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RDESTINATARIO )),10), 
         SUBSTRING(CONVERT(VARCHAR,CONTA.CHEGADA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,CONTA.CHEGADA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,CONTA.CHEGADA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.REMITENTE )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( CONTA.RPORTADOR )),10),
         CONVERT(DATETIME, CONTA.CHEGADA) ,
         DATEPART(DW,CONVERT(DATETIME,CONTA.CHEGADA))

INSERT INTO NIVEL5FSC
SELECT   RIGHT('0000000000' + LTRIM(RTRIM( CAIXA.RITEM )),10), 
         SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTIPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RFONTEPAGADORA )),10),
         '04',
         CONVERT(DATETIME, FATO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,FATO.DATA)),                 
         ISNULL(SUM(CONVERT(FLOAT, FATO.VALOR)),0), 0,0,0,0,0,0,0,0,0
FROM    BDSICAP..FATOFINANCEIRO_R FATO, BDSICAP..CAIXABANCARIA_R CAIXA
WHERE 
        FATO.RFONTEPAGADORA = CAIXA.OID AND
	FATO.OID > 7 AND DATA IS NOT NULL AND FATO.RATOFINANCEIRO = 7 AND SINAL = -1
GROUP BY
         RIGHT('0000000000' + LTRIM(RTRIM( CAIXA.RITEM )),10), 
         SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,7,4) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103),4,2) + SUBSTRING(CONVERT(VARCHAR,FATO.DATA,103) ,1,2),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RTIPO )),10),
         RIGHT('0000000000' + LTRIM(RTRIM( FATO.RFONTEPAGADORA )),10),
         CONVERT(DATETIME, FATO.DATA) ,
         DATEPART(DW,CONVERT(DATETIME,FATO.DATA))

INSERT INTO nivel4FSC SELECT NIVEL4, NIVEL1, NIVEL2, NIVEL3,DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel5FSC
                      GROUP BY NIVEL4, NIVEL1, NIVEL2, NIVEL3, DATA, DIASEM;
GO

INSERT INTO nivel3FSC SELECT NIVEL3, NIVEL1, NIVEL2, DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel4FSC
                      GROUP BY NIVEL3, NIVEL1, NIVEL2, DATA, DIASEM;
GO

INSERT INTO nivel2FSC SELECT NIVEL2, NIVEL1, DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel3FSC
                      GROUP BY NIVEL2, NIVEL1, DATA, DIASEM;
GO

INSERT INTO nivel1FSC SELECT NIVEL1, DATA, DIASEM, SUM( ATR1 ),
                          SUM( ATR2 ), SUM( ATR3 ), SUM( ATR4 ), SUM( ATR5 ), SUM( ATR6 ),
                          SUM( ATR7 ), SUM( ATR8 ), SUM( ATR9 ), SUM( ATR10 )
                      FROM nivel2FSC
                      GROUP BY NIVEL1, DATA, DIASEM;
GO

INSERT INTO TAB_NIVEL1FSC (NIVEL1, DESCRICAO) SELECT DISTINCT NIVEL1, 'DATA ' + NIVEL1 
                          FROM nivel1FSC
                          WHERE NOT EXISTS (SELECT NIVEL1 FROM TAB_NIVEL1FSC WHERE
                          TAB_NIVEL1FSC.NIVEL1=NIVEL1FSC.NIVEL1)
GO
INSERT INTO TAB_NIVEL2FSC (NIVEL2, DESCRICAO) SELECT DISTINCT NIVEL2, 'TPO ' + NIVEL2
                          FROM nivel2FSC
                          WHERE NOT EXISTS (SELECT NIVEL2 FROM TAB_NIVEL2FSC WHERE
                          TAB_NIVEL2FSC.NIVEL2=NIVEL2FSC.NIVEL2)
GO
INSERT INTO TAB_NIVEL3FSC (NIVEL3, DESCRICAO) SELECT DISTINCT NIVEL3, 'CLIENTE/FORNECEDOR ' + NIVEL3
                          FROM nivel3FSC
                          WHERE NOT EXISTS (SELECT NIVEL3 FROM TAB_NIVEL3FSC WHERE
                          TAB_NIVEL3FSC.NIVEL3=NIVEL3FSC.NIVEL3)
GO
INSERT INTO TAB_NIVEL4FSC (NIVEL4, DESCRICAO) SELECT DISTINCT NIVEL4, 'BANCO ' + NIVEL4
                          FROM nivel4FSC
                          WHERE NOT EXISTS (SELECT NIVEL4 FROM TAB_NIVEL4FSC WHERE
                          TAB_NIVEL4FSC.NIVEL4=NIVEL4FSC.NIVEL4)
GO
INSERT INTO TAB_NIVEL5FSC (NIVEL5, DESCRICAO) SELECT DISTINCT NIVEL5, 'FILIAL ' + NIVEL5
                          FROM nivel5FSC
                          WHERE NOT EXISTS (SELECT NIVEL5 FROM TAB_NIVEL5FSC WHERE
                          TAB_NIVEL5FSC.NIVEL5 = NIVEL5FSC.NIVEL5)
GO

UPDATE TAB_NIVEL1FSC SET MES      = SUBSTRING ( NIVEL1,5,2) + '/' + LEFT(NIVEL1,4),
		      BIMESTRE = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '05' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '05' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '06' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '06' +  '/' + LEFT(NIVEL1,4)
			END,
		      TRIMESTRE = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '04' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '04' +  '/' + LEFT(NIVEL1,4)
			END,
		      QUADRIMESTRE  = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '03' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '03' +  '/' + LEFT(NIVEL1,4)
			END,
		      SEMESTRE  = CASE SUBSTRING (NIVEL1, 5,2) 
                      WHEN '01' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '02' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '03' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '04' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '05' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '06' THEN '01' +  '/' + LEFT(NIVEL1,4)
                      WHEN '07' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '08' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '09' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '10' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '11' THEN '02' +  '/' + LEFT(NIVEL1,4)
                      WHEN '12' THEN '02' +  '/' + LEFT(NIVEL1,4)
			END,
			ANO = LEFT(NIVEL1,4),
		      DIAUTIL  = CASE DATEPART(DW,CONVERT(DATETIME,NIVEL1)) 
                      WHEN '1' THEN 'N'
                      WHEN '2' THEN 'S' 
                      WHEN '3' THEN 'S' 
                      WHEN '4' THEN 'S' 
                      WHEN '5' THEN 'S' 
                      WHEN '6' THEN 'S' 
                      WHEN '7' THEN 'N' 
			END
GO
UPDATE TAB_NIVEL2FSC SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL2FSC, BDSICAP..TPO_R
           WHERE NIVEL2 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO
UPDATE TAB_NIVEL3fSC SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL3fSC, BDSICAP..PESSOA_R
           WHERE NIVEL3 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO
UPDATE TAB_NIVEL4fSC SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL4fSC, BDSICAP..ITEM_R
           WHERE NIVEL4 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO
UPDATE TAB_NIVEL5fSC SET DESCRICAO = upper(NOME)
           FROM TAB_NIVEL5fSC, BDSICAP..PESSOA_R
           WHERE NIVEL5 = RIGHT('00000000000' + LTRIM(RTRIM( OID )),10)
GO
